// 1_motifs.js
// This file retrieves all available motifs and stores them in motifs.json

// Includes
var request = require('request');
var http = require('http');
var fs = require('fs');
http.globalAgent.maxSockets = 1000;

// Configuration
var api_url = 'https://v4.alphapicture.com';
var api_username = 'your_username_here';
var api_password = 'your_password_here';

// Code

request({
    uri : api_url + '/Motifs',
    method : "GET",
    headers : {
        'APIV4-Account' : api_username,
        'APIV4-Password' : api_password
    }
}, function(error, response, body) {
    fs.writeFile('./motifs.json', JSON.stringify(JSON.parse(body), null, 4), function(err) {
        if (err) {
            console.log(err);
        } else {
            console.log("Motif JSON saved to motifs.json");
        }
    });
});
